-------------------------------------------------------------------------
-- APELLIDOS: 
-- NOMBRE:
-- MAQUINA
-------------------------------------------------------------------------

type NombrePartido	= String
type NumeroDeDiputados 	= Int
type NumeroDeVotos     	= Int

data Partido a = P NombrePartido a deriving Show

type PartidoYVotos 	= Partido NumeroDeVotos 	
-- nombre del partido con los votos obtenidos

type PartidoYDiputados	= Partido NumeroDeDiputados	
-- nombre del partido con los diputados obtenidos

mRO,mR :: [PartidoYVotos]
mRO = [P "PSOE" 17000, P "PP" 11000, P "IU" 8000]
mR = [P "IU" 16000, P "PSOE" 21000, P "PP" 22000]

mP :: PartidoYVotos
mP = P "PSOE" 21000

-------------------------------------------
--- A 
-------------------------------------------
-- Construir una funcin que inserta un P en una lista ordenada por votos de Ps

insertaV :: PartidoYVotos -> [PartidoYVotos] -> [PartidoYVotos]
votos    :: PartidoYVotos -> NumeroDeVotos

votos (P n x) = x
insertaV v [] = [v]
insertaV v (v':vs) 
	| votos v > votos v' = v:v':vs
	| otherwise = v':insertaV v vs

---------------------------------------------------
-- B
-- Ordenar una lista de votos
---------------------------------------------------
ordenaV :: [PartidoYVotos] -> [PartidoYVotos]
ordenaV vs = foldr insertaV [] vs

-------------------------------------------
--- C 
-------------------------------------------
-- Sumar los votos de un P a los de una [PartidoYVotos]
sumaV :: PartidoYVotos -> [PartidoYVotos] -> [PartidoYVotos]
sumaV v [] = [v]
sumaV (P n x) (P n' y : vs)
	| n == n'   = P n (x+y) : vs
	| otherwise = insertaV (P n' y) (sumaV (P n x) vs)

-------------------------------------------
--- D 
-------------------------------------------
-- Dada dos listas de votos, juntar los votos de cada P
juntarV :: [PartidoYVotos] -> [PartidoYVotos] -> [PartidoYVotos]
juntarV = foldr sumaV 

-------------------------------------------
--- E 
-------------------------------------------
-- Ley d'Hont "simplificada". Se trata de repartir n puestos de diputado entre los Ps que han sido
-- votados en unas elecciones ([PartidoYVotos]).
-- El reparto se hace de la siguiente manera.
-- Se toma una lista ordenada con los votos por P
-- Mientras queden puestos a repartir
--   Se extre el P con mas votos de la lista
--   Se le incrementa uno en los candidatos
--   Se incluye en la lista con la mitad de los votos
-- Al final se debe obtener una lista de todos los Ps con los candidatos obtenidos

d'Hont :: NumeroDeDiputados -> [PartidoYVotos] -> [PartidoYDiputados]
d'Hont n vs = reparte n [] vs
reparte  0    cs  _     = cs
reparte (n+1) cs (P p x : vs) =   reparte n 
  			            (sumaV (P p 1) cs)
                                    (insertaV (P p (x `div`2)) vs)

-- esta es la solucin de Hugo Conde O'Donnell 
-- d'Hont 0 vs = []
-- d'Hont n (P nom vot:xs) = sumaV (P nom 1) 
--        		(d'Hont (n-1) (insertaV (P nom (vot `div` 2)) xs))
